<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/api/metric.proto

namespace Google\Api;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines a metric type and its schema. Once a metric descriptor is created,
 * deleting or altering it stops data collection and makes the metric type's
 * existing data unusable.
 *
 * Generated from protobuf message <code>google.api.MetricDescriptor</code>
 */
class MetricDescriptor extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the metric descriptor. Depending on the
     * implementation, the name typically includes: (1) the parent resource name
     * that defines the scope of the metric type or of its data; and (2) the
     * metric's URL-encoded type, which also appears in the `type` field of this
     * descriptor. For example, following is the resource name of a custom
     * metric within the GCP project `my-project-id`:
     *     "projects/my-project-id/metricDescriptors/custom.googleapis.com%2Finvoice%2Fpaid%2Famount"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded.  All user-defined custom metric types have the DNS name
     * `custom.googleapis.com`.  Metric types should use a natural hierarchical
     * grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "appengine.googleapis.com/http/server/response_latencies"
     *
     * Generated from protobuf field <code>string type = 8;</code>
     */
    private $type = '';
    /**
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     *
     * Generated from protobuf field <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     */
    private $labels;
    /**
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     *
     * Generated from protobuf field <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     */
    private $metric_kind = 0;
    /**
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     *
     * Generated from protobuf field <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     */
    private $value_type = 0;
    /**
     * The unit in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The
     * supported units are a subset of [The Unified Code for Units of
     * Measure](http://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10**3)
     * * `M`     mega    (10**6)
     * * `G`     giga    (10**9)
     * * `T`     tera    (10**12)
     * * `P`     peta    (10**15)
     * * `E`     exa     (10**18)
     * * `Z`     zetta   (10**21)
     * * `Y`     yotta   (10**24)
     * * `m`     milli   (10**-3)
     * * `u`     micro   (10**-6)
     * * `n`     nano    (10**-9)
     * * `p`     pico    (10**-12)
     * * `f`     femto   (10**-15)
     * * `a`     atto    (10**-18)
     * * `z`     zepto   (10**-21)
     * * `y`     yocto   (10**-24)
     * * `Ki`    kibi    (2**10)
     * * `Mi`    mebi    (2**20)
     * * `Gi`    gibi    (2**30)
     * * `Ti`    tebi    (2**40)
     * **Grammar**
     * The grammar includes the dimensionless unit `1`, such as `1/s`.
     * The grammar also includes these connectors:
     * * `/`    division (as an infix operator, e.g. `1/s`).
     * * `.`    multiplication (as an infix operator, e.g. `GBy.d`)
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = [ PREFIX ] UNIT [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT` and is
     *    equivalent to `1` if it is used alone. For examples,
     *    `{requests}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing '{' or '}'.
     *
     * Generated from protobuf field <code>string unit = 5;</code>
     */
    private $unit = '';
    /**
     * A detailed description of the metric, which can be used in documentation.
     *
     * Generated from protobuf field <code>string description = 6;</code>
     */
    private $description = '';
    /**
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     *
     * Generated from protobuf field <code>string display_name = 7;</code>
     */
    private $display_name = '';

    public function __construct() {
        \GPBMetadata\Google\Api\Metric::initOnce();
        parent::__construct();
    }

    /**
     * The resource name of the metric descriptor. Depending on the
     * implementation, the name typically includes: (1) the parent resource name
     * that defines the scope of the metric type or of its data; and (2) the
     * metric's URL-encoded type, which also appears in the `type` field of this
     * descriptor. For example, following is the resource name of a custom
     * metric within the GCP project `my-project-id`:
     *     "projects/my-project-id/metricDescriptors/custom.googleapis.com%2Finvoice%2Fpaid%2Famount"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the metric descriptor. Depending on the
     * implementation, the name typically includes: (1) the parent resource name
     * that defines the scope of the metric type or of its data; and (2) the
     * metric's URL-encoded type, which also appears in the `type` field of this
     * descriptor. For example, following is the resource name of a custom
     * metric within the GCP project `my-project-id`:
     *     "projects/my-project-id/metricDescriptors/custom.googleapis.com%2Finvoice%2Fpaid%2Famount"
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded.  All user-defined custom metric types have the DNS name
     * `custom.googleapis.com`.  Metric types should use a natural hierarchical
     * grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "appengine.googleapis.com/http/server/response_latencies"
     *
     * Generated from protobuf field <code>string type = 8;</code>
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * The metric type, including its DNS name prefix. The type is not
     * URL-encoded.  All user-defined custom metric types have the DNS name
     * `custom.googleapis.com`.  Metric types should use a natural hierarchical
     * grouping. For example:
     *     "custom.googleapis.com/invoice/paid/amount"
     *     "appengine.googleapis.com/http/server/response_latencies"
     *
     * Generated from protobuf field <code>string type = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkString($var, True);
        $this->type = $var;

        return $this;
    }

    /**
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     *
     * Generated from protobuf field <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * The set of labels that can be used to describe a specific
     * instance of this metric type. For example, the
     * `appengine.googleapis.com/http/server/response_latencies` metric
     * type has a label for the HTTP response code, `response_code`, so
     * you can look at latencies for successful responses or just
     * for responses that failed.
     *
     * Generated from protobuf field <code>repeated .google.api.LabelDescriptor labels = 2;</code>
     * @param \Google\Api\LabelDescriptor[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Api\LabelDescriptor::class);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     *
     * Generated from protobuf field <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     * @return int
     */
    public function getMetricKind()
    {
        return $this->metric_kind;
    }

    /**
     * Whether the metric records instantaneous values, changes to a value, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     *
     * Generated from protobuf field <code>.google.api.MetricDescriptor.MetricKind metric_kind = 3;</code>
     * @param int $var
     * @return $this
     */
    public function setMetricKind($var)
    {
        GPBUtil::checkEnum($var, \Google\Api\MetricDescriptor_MetricKind::class);
        $this->metric_kind = $var;

        return $this;
    }

    /**
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     *
     * Generated from protobuf field <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     * @return int
     */
    public function getValueType()
    {
        return $this->value_type;
    }

    /**
     * Whether the measurement is an integer, a floating-point number, etc.
     * Some combinations of `metric_kind` and `value_type` might not be supported.
     *
     * Generated from protobuf field <code>.google.api.MetricDescriptor.ValueType value_type = 4;</code>
     * @param int $var
     * @return $this
     */
    public function setValueType($var)
    {
        GPBUtil::checkEnum($var, \Google\Api\MetricDescriptor_ValueType::class);
        $this->value_type = $var;

        return $this;
    }

    /**
     * The unit in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The
     * supported units are a subset of [The Unified Code for Units of
     * Measure](http://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10**3)
     * * `M`     mega    (10**6)
     * * `G`     giga    (10**9)
     * * `T`     tera    (10**12)
     * * `P`     peta    (10**15)
     * * `E`     exa     (10**18)
     * * `Z`     zetta   (10**21)
     * * `Y`     yotta   (10**24)
     * * `m`     milli   (10**-3)
     * * `u`     micro   (10**-6)
     * * `n`     nano    (10**-9)
     * * `p`     pico    (10**-12)
     * * `f`     femto   (10**-15)
     * * `a`     atto    (10**-18)
     * * `z`     zepto   (10**-21)
     * * `y`     yocto   (10**-24)
     * * `Ki`    kibi    (2**10)
     * * `Mi`    mebi    (2**20)
     * * `Gi`    gibi    (2**30)
     * * `Ti`    tebi    (2**40)
     * **Grammar**
     * The grammar includes the dimensionless unit `1`, such as `1/s`.
     * The grammar also includes these connectors:
     * * `/`    division (as an infix operator, e.g. `1/s`).
     * * `.`    multiplication (as an infix operator, e.g. `GBy.d`)
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = [ PREFIX ] UNIT [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT` and is
     *    equivalent to `1` if it is used alone. For examples,
     *    `{requests}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing '{' or '}'.
     *
     * Generated from protobuf field <code>string unit = 5;</code>
     * @return string
     */
    public function getUnit()
    {
        return $this->unit;
    }

    /**
     * The unit in which the metric value is reported. It is only applicable
     * if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The
     * supported units are a subset of [The Unified Code for Units of
     * Measure](http://unitsofmeasure.org/ucum.html) standard:
     * **Basic units (UNIT)**
     * * `bit`   bit
     * * `By`    byte
     * * `s`     second
     * * `min`   minute
     * * `h`     hour
     * * `d`     day
     * **Prefixes (PREFIX)**
     * * `k`     kilo    (10**3)
     * * `M`     mega    (10**6)
     * * `G`     giga    (10**9)
     * * `T`     tera    (10**12)
     * * `P`     peta    (10**15)
     * * `E`     exa     (10**18)
     * * `Z`     zetta   (10**21)
     * * `Y`     yotta   (10**24)
     * * `m`     milli   (10**-3)
     * * `u`     micro   (10**-6)
     * * `n`     nano    (10**-9)
     * * `p`     pico    (10**-12)
     * * `f`     femto   (10**-15)
     * * `a`     atto    (10**-18)
     * * `z`     zepto   (10**-21)
     * * `y`     yocto   (10**-24)
     * * `Ki`    kibi    (2**10)
     * * `Mi`    mebi    (2**20)
     * * `Gi`    gibi    (2**30)
     * * `Ti`    tebi    (2**40)
     * **Grammar**
     * The grammar includes the dimensionless unit `1`, such as `1/s`.
     * The grammar also includes these connectors:
     * * `/`    division (as an infix operator, e.g. `1/s`).
     * * `.`    multiplication (as an infix operator, e.g. `GBy.d`)
     * The grammar for a unit is as follows:
     *     Expression = Component { "." Component } { "/" Component } ;
     *     Component = [ PREFIX ] UNIT [ Annotation ]
     *               | Annotation
     *               | "1"
     *               ;
     *     Annotation = "{" NAME "}" ;
     * Notes:
     * * `Annotation` is just a comment if it follows a `UNIT` and is
     *    equivalent to `1` if it is used alone. For examples,
     *    `{requests}/s == 1/s`, `By{transmitted}/s == By/s`.
     * * `NAME` is a sequence of non-blank printable ASCII characters not
     *    containing '{' or '}'.
     *
     * Generated from protobuf field <code>string unit = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setUnit($var)
    {
        GPBUtil::checkString($var, True);
        $this->unit = $var;

        return $this;
    }

    /**
     * A detailed description of the metric, which can be used in documentation.
     *
     * Generated from protobuf field <code>string description = 6;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * A detailed description of the metric, which can be used in documentation.
     *
     * Generated from protobuf field <code>string description = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     *
     * Generated from protobuf field <code>string display_name = 7;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A concise name for the metric, which can be displayed in user interfaces.
     * Use sentence case without an ending period, for example "Request count".
     *
     * Generated from protobuf field <code>string display_name = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

}

